<?php

namespace Modules\BusinessManagement\Http\Controllers\Web\Admin\Configuration;

use App\Http\Controllers\BaseController;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\View\View;
use Modules\BusinessManagement\Http\Requests\FirebaseOtpSetupStoreOrUpdateRequest;
use Modules\BusinessManagement\Service\Interface\BusinessSettingServiceInterface;
use Modules\Gateways\Traits\Processor;

class FirebaseOtpController extends BaseController
{
    use Processor;

    protected $businessSettingService;
    public function __construct(BusinessSettingServiceInterface $businessSettingService)
    {
        parent::__construct($businessSettingService);
        $this->businessSettingService = $businessSettingService;
    }

    public function index(?Request $request, string $type = null): View|Collection|LengthAwarePaginator|null|callable|RedirectResponse
    {
        return parent::index($request, $type); // TODO: Change the autogenerated stub
    }

    public function firebaseOtpConfigGet(): Application|Factory|\Illuminate\Contracts\View\View|\Illuminate\Foundation\Application
    {
        $firebaseOtpValues = $this->businessSettingService->getBy(criteria: ['settings_type' => FIREBASE_OTP]);
        return view('businessmanagement::admin.configuration.firebase-otp', compact('firebaseOtpValues'));
    }

    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return RedirectResponse
     */
    public function firebaseOtpConfigSet(FirebaseOtpSetupStoreOrUpdateRequest $request): RedirectResponse
    {
        $this->businessSettingService->storeOrUpdateFirebaseOtpSetting($request->validated());
        Toastr::success(DEFAULT_UPDATE_200['message']);
        return back();
    }
}
