<?php

namespace Modules\BusinessManagement\Http\Controllers\Web\Admin\Configuration;

use App\Http\Controllers\BaseController;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\View\View;
use Modules\BusinessManagement\Http\Requests\PaymentConfigSetupStoreOrUpdateRequest;
use Modules\BusinessManagement\Service\Interface\SettingServiceInterface;
use Modules\Gateways\Traits\Processor;

class PaymentConfigController extends BaseController
{
    use Processor;

    protected $settingService;

    public function __construct(SettingServiceInterface $settingService)
    {
        parent::__construct($settingService);
        $this->settingService = $settingService;
    }

    public function index(?Request $request, string $type = null): View|Collection|LengthAwarePaginator|null|callable|RedirectResponse
    {
        return parent::index($request, $type); // TODO: Change the autogenerated stub
    }

    public function paymentConfigGet()
    {
        $dataValues = $this->settingService->getBy(criteria: ['settings_type' => PAYMENT_CONFIG]);
        return view('businessmanagement::admin.configuration.payment-methods', compact('dataValues'));
    }


    public function paymentConfigSet(PaymentConfigSetupStoreOrUpdateRequest $request)
    {
        $this->settingService->storeOrUpdatePaymentSetting($request->validated());
        Toastr::success(DEFAULT_UPDATE_200['message']);
        return back();
    }
}
