<form action="{{ route('admin.business.setup.chatting-setup.support-saved-reply.update',  $savedReply?->id) }}" method="post" id="updateForm" class="">
    @csrf
    <div class="modal-header border-0">
        <button type="button" class="btn-close outline-none shadow-none" data-bs-dismiss="modal"
                aria-label="Close">
        </button>
    </div>
    <div class="modal-body pt-0">
        <div class="mb-20">
            <h5 class="mb-2">{{ translate('Edit Topic & Answer') }}</h5>
            <div class="fs-12">
                {{ translate('Here you can set Predefine Answer that Admin when send message') }}
            </div>
        </div>
        <div class="p-30 rounded bg-F6F6F6">
            <div class="mb-20">
                <label for="" class="form-label">{{ translate('Topic') }}</label>
                <div class="character-count">
                                    <textarea id="topic" name="topic" class="form-control character-count-field"
                                              cols="30" rows="1"
                                              placeholder="{{ translate('Ex: How to cancel a trip during ongoing trip?') }}"
                                              maxlength="150"
                                              data-max-character="150"
                                              required>{{ $savedReply->topic }}</textarea>
                    <span class="d-flex justify-content-end">{{ translate('0/150') }}</span>
                </div>
            </div>
            <div class="mb-20">
                <label for="" class="form-label">{{ translate('Answer') }}</label>
                <div class="character-count">
                                    <textarea id="answer" name="answer" class="form-control character-count-field"
                                              cols="30" rows="2"
                                              placeholder="{{ translate('Type answer here') }}" maxlength="250"
                                              data-max-character="250" required>{{ $savedReply->answer }}</textarea>
                    <span class="d-flex justify-content-end">{{ translate('0/250') }}</span>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="d-flex gap-3 justify-content-end">
            <button class="btn btn-light h-40px min-w-100px justify-content-center fw-semibold"
                    data-bs-dismiss="modal" type="button">{{ translate('Cancel') }}</button>
            <button type="submit"
                class="btn btn-primary h-40px min-w-100px justify-content-center fw-semibold">{{ translate('Update') }}</button>
        </div>
    </div>
</form>
