<?php

namespace Modules\UserManagement\Http\Controllers\Web\New\Admin;

use App\Http\Controllers\BaseController;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\View\View;
use Modules\TransactionManagement\Service\Interface\TransactionServiceInterface;
use Modules\TransactionManagement\Traits\TransactionTrait;
use Modules\UserManagement\Service\Interface\DriverServiceInterface;

class CashCollectController extends BaseController
{
    use TransactionTrait;

    protected $driverService;
    protected $transactionService;

    public function __construct(DriverServiceInterface $driverService, TransactionServiceInterface $transactionService)
    {
        parent::__construct($driverService);
        $this->driverService = $driverService;
        $this->transactionService = $transactionService;
    }

    public function index(?Request $request, string $type = null): View|Collection|LengthAwarePaginator|null|callable|RedirectResponse
    {
        return parent::index($request, $type); // TODO: Change the autogenerated stub
    }

    public function show(string|int $id)
    {
        $driver = $this->driverService->findOne(id: $id);
        if ($driver) {
            $transactions = $this->transactionService->getBy(criteria: ['user_id' => $id, 'attribute' => 'admin_cash_collect'],orderBy: ['created_at'=>'desc'], limit: paginationLimit(), offset: 1);
            return view('usermanagement::admin.driver.withdraw.collect-cash', compact('driver', 'transactions'));
        }
        return redirect()->route('admin.drivers.index');


    }


    public function collect(string|int $id, Request $request)
    {
        $request->validate([
            'amount' => 'required|gt:0'
        ]);

        $driver = $this->driverService->findOne(id: $id, relations: ['userAccount']);
        if ($request->amount > ($driver?->userAccount?->payable_balance - $driver?->userAccount?->receivable_balance)) {

            Toastr::error(AMOUNT_400['message']);
            return back();
        }
        if ($driver?->userAccount?->receivable_balance == 0){
            $this->collectCashWithoutAdjustTransaction($driver, $request->amount);

        }elseif ($driver?->userAccount?->receivable_balance >0 && $driver?->userAccount?->payable_balance > $driver?->userAccount?->receivable_balance){
            $this->collectCashWithAdjustTransaction($driver, $request->amount);
        }
        Toastr::success(DEFAULT_UPDATE_200['message']);
        return back();
    }
}
