<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\TripManagement\Entities\TripRequest;
use Modules\UserManagement\Entities\User;

class CustomerTripRequestEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $user;
    public $tripRequest;
    /**
     * Create a new event instance.
     */
    public function __construct(User $user, TripRequest $tripRequest)
    {
        $this->user = $user;
        $this->tripRequest = $tripRequest;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
            new PrivateChannel("customer-trip-request.{$this->user->id}"),
        ];
    }

    public function broadcastAs()
    {
        return "customer-trip-request.{$this->user->id}";
    }

    public function broadcastWith()
    {
        return [
            'id'=>$this->user->id,
            'trip_id'=>$this->tripRequest->id
        ];
    }
}
